#include <bits/stdc++.h>
using namespace std;


string to_binary(int n) {
    const size_t bits = sizeof(int) * std::numeric_limits<unsigned char>::digits; 
    std::bitset<32> binary_representation(n);
    return binary_representation.to_string();
}


int to_decimal(string n) {
    int decimalNumber = std::stoi(n, nullptr, 2); 
    return decimalNumber;
}

string customXOR(string a, string b) {
    string c = "";
    for(int i = 0; i < a.length(); i++) {
        if(a[i] == b[i]) {
            c.push_back('0');
        }
        else{
            c.push_back('1');
        }
    }
    return c;
}

string customAND(string a,string b) {
    string c = "";
    size_t min_len = min(a.length(), b.length());

    for (size_t i = 0; i < min_len; ++i) {
        if (a[i] == '1' and b[i] == '1') {
            c.push_back('1');
        } 
        else {
            c.push_back('0');
        }
    }
    return c;
}

void napravi_matrice(vector<vector<bool>>& sablon, vector<vector<bool>>& A, int N) {
    for(int i = 0; i < N; i++) {
        for(int j = i; j < N; j++) {
            if(sablon[A[i]][A[j]]) {
                A[i][j] = true;
            }
            else{
                if(i == j) {
                    sablon[A[i]][A[j]] = true;
                }
                else{
                    sablon[A[i]][A[j]] = to_decimal(customAND(to_binary(A[i]), to_binary(A[j]))) > to_decimal(customXOR(to_binary(A[i]), to_binary(A[j])));
                }
                A[i][j] = sablon[A[i]][A[j]];
            }
        }
    }
    
}

int upit(int L, int R, const vector<int>& A) {
    L--;
    R--;
    int max_niz = 0;
    int trenutni_niz = 0;

    for(int i = L; i < R; i++) {
        for(int j = i+1; j <= R; j++) {
            
            cout << "A[" << i << "] = " << A[i] << "  A[" << j << "] = " << A[j] << '\n';
            //cout << "binarno: " << to_binary(A[i]) << " i " << to_binary(A[j]) << '\n';
            //cout << "AND: " << customAND(to_binary(A[i]), to_binary(A[j])) << "  XOR:" << customXOR(to_binary(A[i]), to_binary(A[j])) << '\n';
            cout << "u decimalno: " << to_decimal(customAND(to_binary(A[i]), to_binary(A[j]))) << " " << to_decimal(customXOR(to_binary(A[i]), to_binary(A[j]))) << '\n';
            
            if(to_decimal(customAND(to_binary(A[i]), to_binary(A[j]))) > to_decimal(customXOR(to_binary(A[i]), to_binary(A[j])))) {
                trenutni_niz++;
            } 
            else {
                max_niz = max(max_niz, trenutni_niz);
                trenutni_niz = 0;
            }
            cout << "**trenutni niz =" << trenutni_niz << '\n';
        }
    }
    max_niz = max(max_niz, trenutni_niz);
    
    return max_niz; 
}




int main()
{
    /*int N;  //broj elemenata niza
    int Q;  //broj upita
    cin >> N >> Q;
    
    
    vector<int> A(N);
    for(int i = 0; i < N; i++) {
        cin >> A[i];
    }
    
    for(int i = 0; i < Q; i++) {
        int L, R;
        cin >> L >> R;
        
        cout << upit(L, R, A);
    }*/
    
    vector<int> A = {1, 2, 1, 3, 2};
    cout << upit(1, 5, A);

    return 0;
}